<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CFaqWidgetQA extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "Q&A List",
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		if (!$widget["settings"]["set_items"]) {
			return "";
		}

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:faq_items']} as r,
				{$this->tables['plugin:faq_items_lang']} as p

			WHERE 
				r.item_id = p.item_id AND 
				p.lang_id = {$widget[lang_id]} AND 
				r.module_id= {$widget[mod_id]} AND 

				r.item_id in ( {$widget['settings']['set_items']} )

			ORDER BY 
				r.item_order ASC
			"
		);

		$items = SortByKeys($items , "item_id" , $widget['settings']['set_items']);


		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$items[$key]["icon"] = $this->tpl->blockReplace($val["item_icon"] ? "Icon" : "NoIcon", $val );
			}			
		}

		return $this->tpl->blockREplacE(
			"Main" , 
			array(

				"items"	=> $base->html->Table(
					$this->tpl, 
					"" , 
					$items
				),
			),
			$widget,
			$widget["settings"]
		);
	}
			

}


?>